package gov.va.med.mhv.phr.appointments.decorator;

import java.util.Date;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import gov.va.med.mhv.phr.decorator.DecoratorUtils;
import gov.va.med.mhv.phr.transfer.Appointment;
import gov.va.med.mhv.phr.transfer.ImpreciseDateComposite;

public class AppointmentDecoratorUtil {
	
    // Appointment Status Strings for MHV for Unkept appointments
    protected static final String APPOINTMENT_NOT_KEPT = "APPOINTMENT NOT KEPT";
    protected static final String APPOINTMENT_CANCELLED = "CANCELLED";
    protected static final String INPATIENT_APPOINTMENT = "INPATIENT APPOINTMENT";
    // CR 4409
    //protected static final String APPOINTMENT_NOT_AVAILABLE = "NOT AVAILABLE";
    
    
    // Appoitnment Status Strings for MHV for kept appointments
    protected static final String FUTURE_APPOINTMENT = "FUTURE";    
    
    // CR 4409
    protected static final String NON_COUNT = "NON-COUNT";
    protected static final String NO_ACTION_TAKEN = "NO ACTION TAKEN";
    protected static final String APPOINTMENT_NOT_APPLICABLE = "NOT APPLICABLE";
    
    protected static final String APPOINTMENT_UPDATE = "UPDATE IN PROGRESS";
    protected static final String APPOINTMENT_KEPT = "APPOINTMENT KEPT";
    protected static final String COMPENSATION_APPT = "This is a Compensation & Pension Appointment";
    
    
    protected static final String BLANK = StringEscapeUtils.escapeHtml("");
    
	public static String getAppointmentStatus(Appointment appointment) {
    	String vistaStatus = appointment.getAppointmentStatus();
    	
    	// Convert the Vista status to an MHV status String
    	if (StringUtils.isBlank(vistaStatus)) {
    			return determineKeptAppointmentStatus(appointment);
    	} else if ("N".equals(vistaStatus) || vistaStatus.equals("NA")) {
        	return escapedValue(APPOINTMENT_NOT_KEPT);
    	} else if (vistaStatus.equals("C")|| vistaStatus.equals("CA") ||
        		 vistaStatus.equals("PC") || vistaStatus.equals("PCA")) {
        	return escapedValue(APPOINTMENT_CANCELLED);
    	} else if (vistaStatus.equals("I")) {
    		return determineKeptAppointmentStatus(appointment);
    	} else if (vistaStatus.equals("NT")) {
    		return escapedValue(APPOINTMENT_NOT_APPLICABLE);
    	} else {
    		return escapedValue("UNKNOWN");
    	}
	}
	
    private static String determineKeptAppointmentStatus(Appointment appt) {
    	String currentStatus = appt.getCurrentStatus();
    	if (currentStatus.equalsIgnoreCase("FUTURE")|| currentStatus.equalsIgnoreCase("INPATIENT/FUTURE")) {
            Date appointmentDate = getAppointmentDate(appt);
            Date today = new Date();
            
            if (appointmentDate.after(today))
            	return escapedValue(FUTURE_APPOINTMENT);
            else
            	return escapedValue(APPOINTMENT_UPDATE); 
    	} else if (currentStatus.equalsIgnoreCase("NON-COUNT") || 
    				currentStatus.equalsIgnoreCase("NO ACTION TAKEN") || 
    				currentStatus.equalsIgnoreCase("NO ACTION TAKEN/TODAY") ||
    				currentStatus.equalsIgnoreCase("INPATIENT/NO ACT TAKN") ||
    				currentStatus.equalsIgnoreCase("INPATIENT/ACT REQ")) {
    		
    		    return escapedValue(APPOINTMENT_NOT_APPLICABLE);
        }
    	else {
    		return escapedValue(APPOINTMENT_KEPT);
    	}
    }
    
    protected static String escapedValue(String value) {
        return StringEscapeUtils.escapeHtml(value);
    }
    
    public static Date getAppointmentDate(Appointment appt) {
    	ImpreciseDateComposite apptDate = appt.getAppointmentDateComposite();
    	Date sortDate = DecoratorUtils.toDate(apptDate);
        if (sortDate == null) {
        	// Not sure what to do here.  We couldn't parse any real Date from 
        	// the ImpreciseDateComposite.  Return now to avoid NPE on sort.
            return new Date();
        } else {
        	return sortDate;
        }
    }
}
